/* 
 *  MonitorUsersRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.MonitoredExecutor;
import com.avaya.ccs.api.UserI;

public class MonitorUsersRequest extends Request {

    private static final Logger LOG = Logger.getLogger(MonitorUsersRequest.class);
    private final String userID;
    private final MonitoredExecutor monitorExe;

    public MonitorUsersRequest(MonitoredExecutor monitorExe, String userID) {
        super(LOG);
        this.monitorExe = monitorExe;
        this.userID = userID;
    }

    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        UserI theUser = getClient().getSession().findUser(userID);
        theUser.monitorUsers(monitorExe);
        LOG.trace(methodName + "-");
        return null;
    }
}
